//
//  GHBiometricsData.h
//  standard
//
//  Created by Echeandia, Augie on 6/18/20.
//  Copyright © 2020 Garmin International. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHBiometricsData class provides the body information data that was extracted from the Garmin device.
 */
@interface GHBiometricsData : NSObject

/** Timestamp for the associated values. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/**
 * The body mass index for the measurement. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *bmi;

/**
 * The body fat percentage for the measurement. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *bodyFat;

/**
 * The bone mass for the measurement in kilograms. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *bone;

/**
 * The skeletal muscle mass for the measurement in kilograms. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *muscleMass;

/**
 * The body water percentage for the measurement. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *water;

/**
 * The weight  for the measurement in kilograms. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *weight;


@end
